class ServiceFormResponseModel {
  ServiceFormResponseModel({
      String? remark, 
      String? status, 
      Data? data,}){
    _remark = remark;
    _status = status;
    _data = data;
}

  ServiceFormResponseModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _status = json['status'].toString();
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  String? _status;
  Data? _data;

  String? get remark => _remark;
  String? get status => _status;
  Data? get data => _data;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['remark'] = _remark;
    map['status'] = _status;
    if (_data != null) {
      map['data'] = _data?.toJson();
    }
    return map;
  }

}

class Data {
  Data({
      Form? form,}){
    _form = form;
}

  Data.fromJson(dynamic json) {
    _form = json['form'] != null ? Form.fromJson(json['form']) : null;
  }
  Form? _form;

  Form? get form => _form;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_form != null) {
      map['form'] = _form?.toJson();
    }
    return map;
  }

}

class Form {
  Form({
      Test1? test1, 
      Trx? trx,}){
    _test1 = test1;
    _trx = trx;
}

  Form.fromJson(dynamic json) {
    _test1 = json['test1'] != null ? Test1.fromJson(json['test1']) : null;
    _trx = json['trx'] != null ? Trx.fromJson(json['trx']) : null;
  }
  Test1? _test1;
  Trx? _trx;

  Test1? get test1 => _test1;
  Trx? get trx => _trx;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_test1 != null) {
      map['test1'] = _test1?.toJson();
    }
    if (_trx != null) {
      map['trx'] = _trx?.toJson();
    }
    return map;
  }

}

class Trx {
  Trx({
      String? name, 
      String? label, 
      String? isRequired, 
      dynamic extensions, 
      List<dynamic>? options, 
      String? type,}){
    _name = name;
    _label = label;
    _isRequired = isRequired;
    _extensions = extensions;
    _options = options;
    _type = type;
}

  Trx.fromJson(dynamic json) {
    _name = json['name']??'';
    _label = json['label'];
    _isRequired = json['is_required'];
    _extensions = json['extensions'];
    if (json['options'] != null) {
      _options = [];
      json['options'].forEach((v) {
        // _options?.add(Dynamic.fromJson(v));
      });
    }
    _type = json['type'];
  }
  String? _name;
  String? _label;
  String? _isRequired;
  dynamic _extensions;
  List<dynamic>? _options;
  String? _type;

  String? get name => _name;
  String? get label => _label;
  String? get isRequired => _isRequired;
  dynamic get extensions => _extensions;
  List<dynamic>? get options => _options;
  String? get type => _type;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['label'] = _label;
    map['is_required'] = _isRequired;
    map['extensions'] = _extensions;
    if (_options != null) {
      map['options'] = _options?.map((v) => v.toJson()).toList();
    }
    map['type'] = _type;
    return map;
  }

}

class Test1 {
  Test1({
      String? name, 
      String? label, 
      String? isRequired, 
      dynamic extensions, 
      List<dynamic>? options, 
      String? type,}){
    _name = name;
    _label = label;
    _isRequired = isRequired;
    _extensions = extensions;
    _options = options;
    _type = type;
}

  Test1.fromJson(dynamic json) {
    _name = json['name'];
    _label = json['label'];
    _isRequired = json['is_required'];
    _extensions = json['extensions'];
    if (json['options'] != null) {
      _options = [];
      json['options'].forEach((v) {
        // _options?.add(Dynamic.fromJson(v));
      });
    }
    _type = json['type'];
  }
  String? _name;
  String? _label;
  String? _isRequired;
  dynamic _extensions;
  List<dynamic>? _options;
  String? _type;

  String? get name => _name;
  String? get label => _label;
  String? get isRequired => _isRequired;
  dynamic get extensions => _extensions;
  List<dynamic>? get options => _options;
  String? get type => _type;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['label'] = _label;
    map['is_required'] = _isRequired;
    map['extensions'] = _extensions;
    if (_options != null) {
      map['options'] = _options?.map((v) => v.toJson()).toList();
    }
    map['type'] = _type;
    return map;
  }

}